//
//  MeetingSDKMgr.h
//  AriesX
//
//  Created by mingfyan on 15/4/24.
//  Copyright (c) 2015 Cisco Systems. All rights reserved.
//

#ifndef __AriesX__MeetingSDKMgr__
#define __AriesX__MeetingSDKMgr__

#include <string>

#include "csfunified/framework/UnifiedFactory.h"
#include "SDKAutoUpgrade.h"

#ifndef _WIN32
typedef void* HMODULE;
#endif

class MeetingSDKMgr : public IAutoUpgradeHandler
{
public:
    
    const static std::string ENTRY_LIB_NAME;
    const static std::string LOCAL_CONFIG_FOLDER_NAME;
    const static std::string LOCAL_CONFIG_FILE_NAME;
    const static std::string DEFAULT_SDK_ARCHIVE_NAME;
    const static std::string INSTALLATION_SDK_SUBFOLDER;
    
    const static long DEFAULT_URL_SCAN_SECONDS;
    const static long LAUNCH_DELAY_SECONDS;
    const static long AUTOUPGRADE_CHECK_SECONDS;
    const static long DOWNLOAD_WAIT_TIMEOUT_SECONDS;
    
    static MeetingSDKMgr* getInstance()
    {
        if (!m_pInstance)
        {
            m_pInstance = new MeetingSDKMgr();
        }
        
        return m_pInstance;
    }
    
	virtual ~MeetingSDKMgr()
	{
		if (m_pInstance)
		{
			delete m_pInstance;
			m_pInstance = NULL;
		}

		if (m_pNetUtilTransportDownloader)
		{
			m_pNetUtilTransportDownloader->CancelAllRequest();

			delete m_pNetUtilTransportDownloader;
			m_pNetUtilTransportDownloader = NULL;
		}
	}

	void setUnifiedFactory(SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> unifiedFactory);
    
    std::string getTargetSDKFolder();
    
    void getLatestSDKVersion(MeetingSDKVersion& version);

	std::string getUserDomain();
    
    bool loadSDKModule();
    HMODULE getSDKModule()
    {
        return m_sdkHandle;
    }
    
    void unloadSDKModule();
    
    bool isAutoUpgradeFeatureEnabled()
    {
        return m_isAutoUpgradeFeatureEnabled;
    }
    
    void startUpgradeCheck();
    
    void stopUpgradeCheck();
    
    // IAutoUpgradeHandler
    virtual std::string getMonitorUrl();
    virtual std::string getDownloadZipPath();
    virtual NetUtilTransportDownloader* getNetUtilTransportDownloader();
    virtual void onQuery(const SDKUpdateQuery& result);
    virtual void downloadToFileComplete(NetUtilDownloadResultEnum::NetUtilDownloadResult result);
    virtual csf::Event* getDownloadCompleteEvent()
    {
        return &m_downloadCompleteEvent;
    }
    virtual long getDownloadWaitTimeoutSeconds()
    {
        return DOWNLOAD_WAIT_TIMEOUT_SECONDS;
    }
    virtual long long getLastCheckTime()
    {
        return LocalSDKConfigs::getInstance()->getLastCheckTime();
    }
    virtual long getUpgradeCheckInterval()
    {
        return m_upgradeCheckInterval;
    }
    
private:
    std::string getRemoteSDKFolder();
    
    void cleanupRemoteSDKFolder();
    
    void getLocalSDKVersion(MeetingSDKVersion& version);
    
    bool loadSDKModuleInternal(std::string folder);
    
    void initNetUtilTransportDownloader()
    {
        if (m_unifiedFactory)
        {
            m_pNetUtilTransportDownloader = new NetUtilTransportDownloader(m_unifiedFactory);
        }
    }
    
    void downloadToFileCompleteInternal(NetUtilDownloadResultEnum::NetUtilDownloadResult result);
    
    std::string getServerUrl()
    {
        return m_serverUrl;
    }
    
    void loadJabberConfigs();
    
    void loadJabberConfigsInternal();
    
private:
    static MeetingSDKMgr* m_pInstance;
    MeetingSDKMgr();
    SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> m_unifiedFactory;
    
    std::string m_localSDKConfigFile;
    
    HMODULE m_sdkHandle;
    std::string m_targetSDKFolder;
    
    TaskDelayTrigger* m_sdkCheckTrigger;
    bool m_sdkCheckerStarted;
    SDKUpdateQuery m_lastQueryResult;
    
    bool m_isAutoUpgradeFeatureEnabled;
    std::string m_serverUrl;
    long m_upgradeCheckInterval;
    
    csf::Event m_downloadCompleteEvent;
    
    NetUtilTransportDownloader* m_pNetUtilTransportDownloader;
    
    static AutoUpgradeTask* m_autoUpgradeTask;
};

#endif /* defined(__AriesX__MeetingSDKMgr__) */
